/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-04-10
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PARAMSPACESCRIPT_H
#define PARAMSPACESCRIPT_H

#include <QGpCoreTools.h>
#include "DinverCoreDLLExport.h"

namespace DinverCore {

class RealSpace;

class DINVERCORE_EXPORT ParamSpaceScript : public XMLClass
{
  TRANSLATIONS("ParamSpaceScript")
public:
  ParamSpaceScript() {}

  const QString& xml_tagName() const {return xmlParamSpaceScriptTag;}
  static const QString xmlParamSpaceScriptTag;

  void setText(QString t) {_text=t;}
  QString text() const {return _text;}

  bool apply(RealSpace * param) const;
protected:
  void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  XMLMember xml_member(XML_MEMBER_ARGS);
  bool xml_setProperty(XML_SETPROPERTY_ARGS);
private:
  QString _text;
};

class DINVERCORE_EXPORT ParamExpressionContext : public ExpressionContext
{
  TRANSLATIONS("ParamExpressionFunctions")
public:
  ParamExpressionContext(RealSpace * param) {_param=param;}

  QStringList functions() const;
  bool isValidFunction(const QString& name) const;
  QVariant functionValue(const QString& name, const VectorList<ExpressionAction *>& args) const;
private:
  RealSpace * _param;
};

} // namespace DinverCore

#endif // PARAMSPACESCRIPT_H
