/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-10-21
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PARAMCONDITION_H
#define PARAMCONDITION_H

#include "AbstractCondition.h"
#include "DinverCoreDLLExport.h"

namespace DinverCore {

  class DINVERCORE_EXPORT ParamCondition
  {
  public:
    ParamCondition();
    ParamCondition(AbstractCondition * c, int paramIndex);

    inline void getLimits(double& min, double& max) const;
    void humanInfo() const {_condition->humanInfo();}
    uint checksum() const {return _condition->checksum();}
  private:
    AbstractCondition * _condition;
    int _paramIndex;
  };

  inline void ParamCondition::getLimits(double& min, double& max) const
  {
    TRACE;
    _condition->getLimits(_paramIndex, min, max);
  }

} // namespace DinverCore

#endif // PARAMCONDITION_H
