/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-07-09
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ARTIFICIALBEECOLONY_H
#define ARTIFICIALBEECOLONY_H

#include <QGpCoreMath.h>

#include "DinverCoreDLLExport.h"

namespace DinverCore {

  class ModelSet;
  class AbstractForward;
  class ReportWriter;

  class DINVERCORE_EXPORT ArtificialBeeColony
  {
  public:
    ArtificialBeeColony(int modelCount, int giveUp, int seed);
    ~ArtificialBeeColony();

    bool setForward(const AbstractForward * f);
    void setStorage();

    bool init();
    void run(int cycleCount);
  private:
    void employedBees();
    void onlookerBees();
    void scoutBees();

    void improveModel(int index);

    int _modelCount, _giveUp;

    AbstractForward * _forward;

    int _parameterCount;
    int _targetCount;
    int * _parameters;
    double * _misfits;
    int * _lastImproved;
    int _cycle;

    Random * _randomNumbers;
    AtomicBoolean _terminated;
    Mutex _reportLock;
    ReportWriter * _report;
    uint _parameterSpaceChecksum;
  };

} // namespace DinverCore

#endif // ARTIFICIALBEECOLONY_H

