/***************************************************************************
**
**  This file is part of ArrayGui.
**
**  ArrayGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-09-13
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef RINGEDITOR_H
#define RINGEDITOR_H

#include <ArrayCore.h>
#include <GeopsyGui.h>

#include "ui_RingEditor.h"
#include "PlotSPACRing.h"
#include "ArrayGuiDLLExport.h"

namespace ArrayGui {

  class RingEditor;

  class RingEditorModel : public QAbstractTableModel
  {
  public:
    RingEditorModel(RingEditor * parent);

    void setArray(const QList<NamedPoint>& array);
    void setArray(const ArraySelection& array);
    void clear();
    void addRing(double minR, double maxR, const Pen& pen);
    void addRing(const Pen& pen);
    void autoRings();
    void removeRings(QModelIndexList l);
    void read(QTextStream& s);
    void write(QTextStream& s) const;

    int rowCount(const QModelIndex &parent=QModelIndex()) const;
    int columnCount(const QModelIndex &parent=QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    QVariant headerData(int section, Qt::Orientation orientation, int role=Qt::DisplayRole) const;
    bool setData(const QModelIndex & index, const QVariant & value, int role=Qt::EditRole);
    Qt::ItemFlags flags (const QModelIndex & index) const;

    const VectorList<PlotSPACRing>& rings() const {return _rings;}
    void setRing(int index, double minR, double maxR);

    Legend legend() const;
    void setLegend(const Legend& l);
  private:
    VectorList<StationPair> _pairs;
    VectorList<PlotSPACRing> _rings;
  };

  class RingEditorDelegate : public ItemDelegate
  {
    Q_OBJECT
  public:
    RingEditorDelegate(QObject *parent=nullptr);

    QWidget * createEditor(QWidget *parent, const QStyleOptionViewItem &option,
                           const QModelIndex &index) const;
    void paint (QPainter * painter, const QStyleOptionViewItem & option,
                const QModelIndex & index) const;
    QSize sizeHint (const QStyleOptionViewItem & option, const QModelIndex & index) const;
  };

  class ARRAYGUI_EXPORT RingEditor : public QWidget, public Ui::RingEditor
  {
    Q_OBJECT
  public:
    RingEditor(QWidget *parent=nullptr, Qt::WindowFlags f=Qt::Widget);
    ~RingEditor();

    const VectorList<PlotSPACRing>& rings() const {return model()->rings();}

    void clear();
    void addRing(double minR, double maxR);
    void setArray(const ArraySelection& array);
    void setArray(const QList<NamedPoint>& array);
    void autoRings() {on_autoBut_clicked();}
    void updateProperties() {}
  public slots:
    void setCoArrayGraph(ArrayMap * w);
  private slots:
    void updateGraph();
    void on_addBut_clicked();
    void on_removeBut_clicked();
    void on_loadBut_clicked();
    void load(QString fileName);
    void on_saveBut_clicked();
    void on_optimizeBut_clicked();
    void on_autoBut_clicked();
    void on_legendBut_clicked();
    void commitLegend();
    void currentChanged();
  private:
    RingEditorModel * model() const;

    CircleViewer * _circleLayer;
    LineLayer * _currentPairs;
    LegendProperties * _legendEditor;
    Legend _legend;
  };

} // namespace ArrayGui

#endif // RINGEDITOR_H
