/***************************************************************************
**
**  This file is part of ArrayGui.
**
**  ArrayGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-07-19
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "BlockAveragingParameterWidget.h"

namespace ArrayGui {

  /*!
    \class BlockAveragingParameterWidget BlockAveragingParameterWidget.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  BlockAveragingParameterWidget::BlockAveragingParameterWidget(QWidget * parent)
    : QWidget(parent)
  {
    TRACE;
    setupUi(this);

    connect(countEdit, SIGNAL(valueChanged(int)), this, SIGNAL(parametersChanged()));
    connect(countFactorEdit, SIGNAL(valueChanged(double)), this, SIGNAL(parametersChanged()));
    connect(statisticCountEdit, SIGNAL(valueChanged(int)), this, SIGNAL(parametersChanged()));
    connect(statisticMaxOverlapEdit, SIGNAL(valueChanged(double)), this, SIGNAL(parametersChanged()));
  }

  /*!
    Description of destructor still missing
  */
  BlockAveragingParameterWidget::~BlockAveragingParameterWidget()
  {
    TRACE;
  }

  void BlockAveragingParameterWidget::updateAllFields()
  {
    TRACE;
    on_countEdit_valueChanged(countEdit->value());
  }

  void BlockAveragingParameterWidget::on_countEdit_valueChanged(int value)
  {
    TRACE;
    countFactorEdit->setEnabled(value==0);
  }

  void BlockAveragingParameterWidget::getParameters(BlockAveragingParameters & param)
  {
    TRACE;
    param.setCount(countEdit->value());
    param.setCountFactor(countFactorEdit->value());
    param.setStatisticCount(statisticCountEdit->value());
    param.setStatisticMaxOverlap(0.01*statisticMaxOverlapEdit->value());
  }

  void BlockAveragingParameterWidget::setParameters(const BlockAveragingParameters & param)
  {
    TRACE;
    countEdit->setValue(param.count());
    countFactorEdit->setValue(param.countFactor());
    statisticCountEdit->setValue(param.statisticCount());
    statisticMaxOverlapEdit->setValue(100.0*param.statisticMaxOverlap());
  }

} // namespace ArrayGui

