/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-11-12
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "SimulatedArrayStations.h"

namespace ArrayCore {

  /*!
    \class SimulatedArrayStations SimulatedArrayStations.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  SimulatedArrayStations::SimulatedArrayStations(const QList<NamedPoint>& array)
    : ArrayStations()
  {
    TRACE;
#if(QT_VERSION>=QT_VERSION_CHECK(6, 0, 0))
    _stations=array;
#else
    _stations=array.toVector();
#endif
  }

  /*!
    Description of destructor still missing
  */
  SimulatedArrayStations::~SimulatedArrayStations()
  {
    TRACE;
  }

  double SimulatedArrayStations::samplingFrequnecy() const
  {
    return 1.0;
  }

  ArrayStations::Mode SimulatedArrayStations::mode() const
  {
    return ThreeComponents;
  }

  int SimulatedArrayStations::count() const
  {
    return _stations.count();
  }

  QString SimulatedArrayStations::name(int index) const
  {
    return _stations.at(index).name();
  }

  Point2D SimulatedArrayStations::position(int index) const
  {
    return _stations.at(index);
  }

  StationSignals * SimulatedArrayStations::stationSignals(int) const
  {
    return nullptr;
  }

} // namespace ArrayCore
