/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-10-25
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SENSORORIENTATIONWORKER_H
#define SENSORORIENTATIONWORKER_H

#include "FKWorker.h"
#include "ArrayCoreDLLExport.h"
#include "SensorOrientationTaskManager.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT SensorOrientationWorker : public FKWorker
  {
  public:
    SensorOrientationWorker(const ArraySelection * array,
                            const FKParameters * param);
    ~SensorOrientationWorker();

    void setOrientationFunction(FKCache * cache);
  protected:
    inline SensorOrientationTaskManager * taskManager() const;

    void process(const VectorList<int>& blocks);
    void polish(ParallelTask * t);
  private:
    bool invert(CrossSpectrumSplit * split);

    OptimizationBFGS _optim;
    PrivateVector<double> _max;
  };

  inline SensorOrientationTaskManager * SensorOrientationWorker::taskManager() const
  {
    return static_cast<SensorOrientationTaskManager *>(ArrayWorker::taskManager());
  }

} // namespace ArrayCore

#endif // SENSORORIENTATIONWORKER_H

