/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-05-14
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SPACPARAMETERS_H
#define SPACPARAMETERS_H

#include "ArrayParameters.h"
#include "RingPairs.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class StationPair;

  class ARRAYCORE_EXPORT SPACParameters : public ArrayParameters
  {
    TRANSLATIONS("SPACParameters")
  public:
    SPACParameters();

    AbstractParameters * clone() const {return new SPACParameters(*this);}

    enum Method {MSPAC, ESAC};
    ENUM_AS_STRING_DECL(Method)

    Method method() const {return _method;}
    void setMethod(Method m) {_method=m;}

    void clearRings();
    void addRing(double minRadius, double maxRadius);
    int ringCount() const {return _rings.count();}
    const VectorList<AutocorrRing>& rings() const {return _rings;}

    void setMaximumImaginary(double m) {_maximumImaginary=m;}
    double maximumImaginary() const {return _maximumImaginary;}

    bool dotMaxOutput() const {return _dotMaxOutput;}
    void setDotMaxOutput(bool o) {_dotMaxOutput=o;}

    QString outputName(const QString& groupName) const;

    QString toString(PARAMETERS_TOSTRING_ARGS_DECL) const;
    void collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS);
  protected:
    int keywordCount(PARAMETERS_KEYWORDCOUNT_ARGS) const;
    bool setValue(PARAMETERS_SETVALUE_ARGS);
  private:
    Method _method;
    VectorList<AutocorrRing> _rings;
    double _maximumImaginary;
    bool _dotMaxOutput;
  };

} // namespace ArrayCore

#endif // SPACPARAMETERS_H
