/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-02-05
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef MSPACSTATISTICS_H
#define MSPACSTATISTICS_H

#include <QGpCoreMath.h>
#include <QGpCoreWave.h>

#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT MSPACStatistics
  {
  public:
    MSPACStatistics();
    ~MSPACStatistics();

    void setParameters(int ringCount, int nComponents);
    void reset();
    inline void addValue(Mode::Polarization polarization, int iRing, double val);
    int count(int iComp) const;

    const Statistics& result(int iRing, int iComp) const {return _stats[iRing][iComp];}
  private:
    int _nRings, _nComp;
    Statistics ** _stats;
  };

  inline void MSPACStatistics::addValue(Mode::Polarization polarization, int iRing, double val)
  {
    switch(polarization) {
    case Mode::Vertical:
      _stats[iRing][0].add(val);
      break;
    case Mode::Radial:
      _stats[iRing][1].add(val);
      break;
    case Mode::Transverse:
      _stats[iRing][2].add(val);
      break;
    case Mode::Rayleigh:
    case Mode::Love:
      ASSERT(false);
    }
  }

} // namespace ArrayCore

#endif // MSPACSTATISTICS_H

