/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-02-05
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "MSPACStatistics.h"

namespace ArrayCore {

  /*!
    \class MSPACStatistics MSPACStatistics.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  MSPACStatistics::MSPACStatistics()
  {
    TRACE;
    _nRings=0;
    _nComp=0;
    _stats=nullptr;
  }

  /*!
    Description of destructor still missing
  */
  MSPACStatistics::~MSPACStatistics()
  {
    TRACE;
    for(int iRing=0;iRing < _nRings; iRing++ ) {
      delete [] _stats[iRing];
    }
    delete [] _stats;
  }

  void MSPACStatistics::reset()
  {
    TRACE;
    for(int iRing=0; iRing<_nRings; iRing++) {
      for(int iComp=0; iComp<_nComp; iComp++){
        _stats[iRing][iComp].reset();
      }
    }
  }

  void MSPACStatistics::setParameters(int ringCount, int nComponents)
  {
    TRACE;
    _nRings=ringCount;
    _nComp=nComponents;
    ASSERT(!_stats);
    _stats=new Statistics*[_nRings];
    for(int iRing=0; iRing<_nRings; iRing++ ){
      _stats[iRing]=new Statistics[_nComp];
    }
  }

  int MSPACStatistics::count(int iComp) const
  {
    int n=0;
    for(int iRing=0; iRing<_nRings; iRing++ ){
      n+=_stats[iRing][iComp].count();
    }
    return n;
  }

} // namespace ArrayCore

