/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-11-12
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef KMINSOLVER_H
#define KMINSOLVER_H

#include <QGpCoreTools.h>
#include <QGpCoreWave.h>
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT KminSolver : public TheoreticalLinearFK
  {
    TRANSLATIONS("KminSolver")
  public:
    KminSolver(const VectorList<Point2D>& stations) : TheoreticalLinearFK(stations) {}

    double calculate(bool& ok);
    double groundLevel(double kminHalf, double kmax);
  };

} // namespace ArrayCore

#endif // KMINSOLVER_H
