/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-10-14
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>

#include "IncoherentNoise.h"

namespace ArrayCore {

  /*!
    \class IncoherentNoise IncoherentNoise.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  IncoherentNoise::IncoherentNoise()
  {
    TRACE;
    _count=0;
    _power=0.0;
    _etaH=0.0;
    _etaZ=0.0;
  }

  void IncoherentNoise::add(double power, double Rh, double Rz)
  {
    if(isnormal(Rh) && isnormal(Rz)) {
      _power+=power;
      _etaH+=Rh*power;
      _etaZ+=Rz*power;
      _count++;
    }
  }

  double IncoherentNoise::R() const
  {
    return (2.0*_etaH/_count+_etaZ/_count)/_power;
  }

  double IncoherentNoise::sigma() const
  {
    return _etaH/_etaZ;
  }

  void IncoherentNoise::showStatus() const
  {
    App::log(tr("Total power %1 Rh %2 Rz %3 R %4 sigma %5 (%6 waves)\n")
             .arg(_power).arg(_etaH/(_count*_power)).arg(_etaZ/(_count*_power)).arg(R()).arg(sigma()).arg(_count));
  }

} // namespace ArrayCore

