/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-11-17
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HRFKRAYLEIGHSQUARED_H
#define HRFKRAYLEIGHSQUARED_H

#include "HRFKRayleigh.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT HRFKRayleighSquared : public HRFKRayleigh
  {
  public:
    HRFKRayleighSquared(FKCache * cache);

    void initialize(const FKParameters& param);

    double value(const Vector<int>& index) const;
    double value(Vector<double>& kell) const;
    double valueFixed(const Vector<double>& kell) const;

    struct Attributes {
      double x, value, slope, concavity;
      double tan, tan2, valueH, valueH2;
      int evaluationCount;
      Complex ell;
    };
    void setFunctionValue(Attributes& a) const;
    void setFunctionDerivatives(Attributes& a) const;

    void setAssociatedResults(const Vector<double>& kell, double power,
                              FKPeaks::Value& val) const;

    double wavenumberNormalizedConcavity(const Vector<double>& kell) const;

    static void showProcessingTime();
  protected:
    mutable Attributes _xi1, _xi2;
  private:
    inline void maximumEllipticity() const;
  };

} // namespace ArrayCore

#endif // HRFKRAYLEIGHSQUARED_H

