/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-06-28
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HRFKDIRECTRAYLEIGH_H
#define HRFKDIRECTRAYLEIGH_H

#include "ConvFKRayleigh.h"
#include "ArrayCoreDLLExport.h"
#include "FKCrossSpectrum.h"

namespace ArrayCore {

  class DirectEllipticityEngine;

  class ARRAYCORE_EXPORT HRFKDirectRayleigh : public ConvFKRayleigh
  {
  public:
    HRFKDirectRayleigh(FKCache * cache);
    ~HRFKDirectRayleigh();

    void initialize(const FKParameters& param);

    void resetCrossSpectrum();
    void addCrossSpectrum();
    void meanCrossSpectrum(int nBlocks);
    void addIncoherentNoise(double horizontal, double vertical);
    bool invertCrossSpectrum();

    const ComplexMatrix * crossSpectrum() const;
  };

} // namespace ArrayCore

#endif // HRFKDIRECTRAYLEIGH_H

