/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-11-22
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HRFKDIRECTLOVE_H
#define HRFKDIRECTLOVE_H

#include "HRFKDirectRayleighAll.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT HRFKDirectLove : public HRFKDirectRayleighAll
  {
  public:
    HRFKDirectLove(FKCache * cache);
    ~HRFKDirectLove();

    void initialize(const FKParameters& param);

    double value(const Vector<int>& index) const;
    double value(Vector<double>& kell) const;

    double ellipticity(const Vector<double>& kell) const;

    bool remove(const Vector<double>& k, double ell, double noise, double power);
  };

} // namespace ArrayCore

#endif // HRFKDIRECTLOVE_H

