/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-11-22
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "HRFKDirectLove.h"
#include "FKCrossSpectrum.h"

namespace ArrayCore {

  /*!
    \class HRFKDirectLove HRFKDirectLove.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  HRFKDirectLove::HRFKDirectLove(FKCache * cache)
    : HRFKDirectRayleighAll(cache)
  {
    TRACE;
  }

  /*!
    Description of destructor still missing
  */
  HRFKDirectLove::~HRFKDirectLove()
  {
    TRACE;
  }

  void HRFKDirectLove::initialize(const FKParameters& param)
  {
    setPowerEngine(new FKPower(cache()->array()->count(), 3));
    if(_crossSpectrum) {
      powerEngine()->setCrossSpectrum(_crossSpectrum->matrix());
    }
    steeringInitialization()->setSensorPositionErrors(param);
    steeringInitialization()->setSensorOrientationErrors(param);
    steeringInitialization()->setPhaseShifts(param.gridStep(), param.effectiveGridSize());
    steeringInitialization()->setTransverseRotations(param.gridStep());
  }

  double HRFKDirectLove::value(const Vector<int>& index) const
  {
    if(isInsideLimits(index)) {
      const Vector<Complex>& e=steering()->threeComponentLove(index, powerEngine());
      powerEngine()->setHighResolutionValue(e);
      return powerEngine()->value();
    } else {
      return -1.0;
    }
  }

  double HRFKDirectLove::value(Vector<double>& kell) const
  {
    if(isInsideLimits(kell)) {
      kell[2]=M_PI/2.0;
      const Vector<Complex>& e=steering()->threeComponentLove(kell, powerEngine());
      powerEngine()->setHighResolutionValue(e);
      return powerEngine()->value();
    } else {
      return -1.0;
    }
  }

  double HRFKDirectLove::ellipticity(const Vector<double>&) const
  {
    return std::numeric_limits<double>::infinity();
  }

  bool HRFKDirectLove::remove(const Vector<double>& k, double, double, double)
  {
    // Get the cross-spectral matrix due to a plane wave travelling at k.
    const Vector<Complex>& q0values=oneComponentSteering(k);
    Angle theta0(k[0], k[1]);
    int n=_crossSpectrum->array().count();
    int n2=n*2;
    ComplexMatrix V0(n2, 1);
    ComplexMatrix q0(n, 1);
    ComplexMatrix q0ct(1, n);
    for(int i=0; i<n; i++) {
      V0.at(i, 0)=-theta0.sin()*q0values[i];
      V0.at(i+n, 0)=theta0.cos()*q0values[i];
      q0.at(i, 0)=q0values[i];
      q0ct.at(0, i)=conjugate(q0values[i]);
    }
    ComplexMatrix Fh=V0*V0.conjugate().transposed();
    ComplexMatrix F(n*3);
    F.zero();
    F.copyAt(0, 0, Fh);
    //_originalCrossSpectrum-=F;
    //_crossSpectrum->matrix()=_originalCrossSpectrum;
    return invertCrossSpectrum();
  }

} // namespace ArrayCore

