/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-08-27
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HRFKANGULARRAYLEIGHELLIPTICITY_H
#define HRFKANGULARRAYLEIGHELLIPTICITY_H

#if 0
#include "HRFKAngularRayleigh.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT HRFKAngularRayleighEllipticity : public HRFKAngularRayleigh
  {
  public:
    HRFKAngularRayleighEllipticity(FKCache * cache);

    void initialize(const FKParameters& param);

    void setK(const Vector<double> * k) {_k=k;}
    void setCrossSpectrum(const ComplexMatrix * crossSpectrum) {_crossSpectrum=crossSpectrum;}

    virtual double powerValue(const Vector<double>& k, double xi, const ComplexMatrix& crossSpectrum) const;

    virtual ComplexMatrix noiseShiftedCrossSpectrum(double whiteNoise) const;
    void setNoise(double xi, const VectorList<Point2D>& nullArrayResponse);
    bool isStableNoise(double xi, double max) const;
    double verticalNoise() const {return _RzOverN;}
    double horizontalNoise() const {return _RhOverN;}
    double correctedEllipticity() const {return _xir;}
    void debugNoiseCurve(const QString& name, const Vector<double>& kell, double freq) const;
    double maximumNoiseDeviation(double xi) const;
  protected:
    double sigmaNull(const VectorList<Point2D>& nullArrayResponse) const;
    double sigmaDk(double p0, double p90) const;
    double sigmaDk(double r, double err, double p0, double p90, double& b2errdk) const;
    void setCorrectedElliticity(double sigma, double xi, double p0, double p90);
    double singularPoint(double p0, double p90) const;

    const Vector<double> * _k;
    const ComplexMatrix * _crossSpectrum;
    double _RzOverN, _RhOverN, _p0, _xir;
  };

  class ARRAYCORE_EXPORT HRFKAngularDirectRayleighEllipticity : public HRFKAngularRayleighEllipticity
  {
  public:
    HRFKAngularDirectRayleighEllipticity(FKCache * cache)
      : HRFKAngularRayleighEllipticity(cache) {}

    void initialize(const FKParameters& param);
    double powerValue(const Vector<double>& k, double xi, const ComplexMatrix& crossSpectrum) const;
    ComplexMatrix noiseShiftedCrossSpectrum(double whiteNoise) const;
  };

} // namespace ArrayCore

#endif
#endif // HRFKANGULARRAYLEIGHELLIPTICITY_H

