/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-02-02
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "HREllipticityEngine.h"
#include "HRFKRayleighRadial.h"
#include "HRFKRayleighVertical.h"
#include "FKCrossSpectrum.h"
#include "FKPower.h"

namespace ArrayCore {

  /*!
    \class HREllipticityEngine HREllipticityEngine.h
    \brief
  */
  HREllipticityEngine::HREllipticityEngine(FKCache * cache, const FKParameters& param)
    : AbstractEllipticityEngine(param)
  {
    _vertical=new HRFKVertical(cache);
    _vertical->initialize(param);
    _radial=new HRFKRadial(cache);
    _radial->initialize(param);

    _rayleighRadial=new HRFKRayleighRadial(cache);
    _rayleighRadial->initialize(param);
    _rayleighVertical=new HRFKRayleighVertical(cache);
    _rayleighVertical->initialize(param);
  }

  HREllipticityEngine::~HREllipticityEngine()
  {
    delete _rayleighRadial;
    delete _rayleighVertical;
  }

  double HREllipticityEngine::radialPower(Vector<double>& kell,
                                          FKCrossSpectrum * crossSpectrum)
  {
    _rayleighRadial->setCrossSpectrum(crossSpectrum->rotatedMatrix(kell));
    return _rayleighRadial->value(kell);
  }

  double HREllipticityEngine::radialWavenumberNormalizedConcavity(Vector<double>& kell)
  {
    return _rayleighRadial->wavenumberNormalizedConcavity(kell);
  }

  double HREllipticityEngine::radialConcavity(Vector<double>& kell, int axis)
  {
    return _rayleighRadial->concavity(kell, axis);
  }

  double HREllipticityEngine::verticalPower(Vector<double> & kell,
                                            FKCrossSpectrum *crossSpectrum)
  {
    _rayleighVertical->setCrossSpectrum(crossSpectrum->rotatedMatrix(kell));
    return _rayleighVertical->value(kell);
  }

  double HREllipticityEngine::verticalWavenumberNormalizedConcavity(Vector<double>& kell)
  {
    return _rayleighVertical->wavenumberNormalizedConcavity(kell);
  }

  double HREllipticityEngine::verticalConcavity(Vector<double>& kell, int axis)
  {
    return _rayleighVertical->concavity(kell, axis);
  }

} // namespace ArrayCore

