/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-06-27
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HRDIRECTELLIPTICITYENGINE_H
#define HRDIRECTELLIPTICITYENGINE_H

#include "AbstractEllipticityEngine.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class HRFKDirectRayleighRadial;
  class HRFKDirectRayleighVertical;

  class ARRAYCORE_EXPORT HRDirectEllipticityEngine: public AbstractEllipticityEngine
  {
  public:
    HRDirectEllipticityEngine(FKCache * cache, const FKParameters& param);
    ~HRDirectEllipticityEngine();

    double radialPower(Vector<double>& kell,
                       FKCrossSpectrum * crossSpectrum);
    double radialWavenumberNormalizedConcavity(Vector<double>& kell);
    double radialConcavity(Vector<double>& kell, int axis);
    double verticalPower(Vector<double>& kell,
                         FKCrossSpectrum * crossSpectrum);
    double verticalWavenumberNormalizedConcavity(Vector<double>& kell);
    double verticalConcavity(Vector<double>& kell, int axis);
  protected:
    HRFKDirectRayleighRadial * _rayleighRadial;
    HRFKDirectRayleighVertical * _rayleighVertical;
  };

} // namespace ArrayCore

#endif // HRDIRECTELLIPTICITYENGINE_H

