/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-11-29
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef FKWORKER_H
#define FKWORKER_H

#include "ArrayCoreDLLExport.h"
#include "ArrayWorker.h"
#include "FKTaskManager.h"
#include "FKCache.h"
#include "FKParameters.h"
#include "FKCrossSpectrum.h"
#include "FKPeaks.h"

namespace ArrayCore {

  class WaveNumberConverter;

  class ARRAYCORE_EXPORT FKWorker : public ArrayWorker
  {
  public:
    FKWorker(const ArraySelection * array,
             const FKParameters * param);
    ~FKWorker();

    virtual bool setGrid(FKCache * cache);
    void setTaskManager(FKTaskManager * tm) {ArrayWorker::setTaskManager(tm);}
    inline AbstractFKFunction * function() const;
  protected:
    inline FKTaskManager * taskManager() const;

    void process(const VectorList<int>& blocks);
    void mergeResults();

    AbstractFKFunction * function();
    void localizeMax();
    bool addPeaks(const WaveNumberConverter& conv);
    void decompose(const WaveNumberConverter& conv);
    bool addPeak(const FunctionSearchMaximum& m, const WaveNumberConverter& conv,
                 const FKParameters * param, AbstractFKFunction * function);
    bool setSlownessRange();
    FKCrossSpectrum * crossSpectrum() {return static_cast<FKCrossSpectrum *>(_crossSpectrum);}

    FunctionSearch * _search;
    FKPeaks _peaks;
  };

  inline FKTaskManager * FKWorker::taskManager() const
  {
    return static_cast<FKTaskManager *>(ArrayWorker::taskManager());
  }

  inline AbstractFKFunction * FKWorker::function() const
  {
    return static_cast<AbstractFKFunction *>(_search->function());
  }

} // namespace ArrayCore

#endif // FKWORKER_H

