/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-03-03
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "FKFunctionPlot.h"

namespace ArrayCore {

  /*!
    \class FKFunctionPlot FKFunctionPlot.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  FKFunctionPlot::FKFunctionPlot(AbstractFKFunction * f)
    : FunctionPlot(3, f)
  {
    _mode=BeamPower;
  }

  /*!
    Description of destructor still missing
  */
  FKFunctionPlot::~FKFunctionPlot()
  {

  }

  /*!
    \fn void FKFunctionPlot::setFixedEllipticity(double xi)

    \a xi is in radians.
    Current mode is not changed. Using another mode than FixedEllipticity
    may change the current value of the fixed ellipticity modified by this
    function.
  */

  double FKFunctionPlot::value(double x, double y) const
  {
    _x[0]=x;
    _x[1]=y;
    switch(_mode) {
    case BeamPower:
      break;
    case InverseBeamPower:
      return 1.0/function()->value(_x);
    case Ellipticity:
      function()->value(_x);
      return Angle::radiansToDegrees(_x[2]);
    case FixedEllipticity:
      return function()->valueFixed(_x);
    case CrossSpectralMatrix: {
        const ComplexMatrix * covmat=function()->crossSpectrum();
        if(covmat) {
          int n=covmat->rowCount()-1;
          int ix=qRound(x)-1;
          int iy=qRound(y)-1;
          if(ix<0) {
            ix=0;
          } else if(ix>n) {
            ix=n;
          }
          if(iy<0) {
            iy=0;
          } else if(iy>n) {
            iy=n;
          }
          return covmat->at(ix, iy).abs();
        } else {
          return std::numeric_limits<double>::quiet_NaN();
        }
      }
    case GradientDirection:
    case Concavity:
    case StepDirection:
      return 0.0;
    }
    return function()->value(_x);
  }

} // namespace ArrayCore
