/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-06-04
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef CROSSSPECTRUM_H
#define CROSSSPECTRUM_H

#include <QGpCoreMath.h>

#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT CrossSpectrum : public CacheItem
  {
  public:
    CrossSpectrum();
    CrossSpectrum(const CrossSpectrum& o);
    virtual ~CrossSpectrum();

    void setRayleigh(int nStations) {_rayleighCrossSpectrum.resize(nStations);}
    void resetLoveCrossSpectrum() {_loveCrossSpectrum.zero();}
    void resetRayleighCrossSpectra();
    void resetLoveCrossSpectra();

  protected:
    virtual bool isAllocated() const;
    virtual qint64 dataSize() const;
  private:
    virtual bool allocate() const;
    virtual void free() const;
    virtual bool save(QDir& d) const;
    virtual bool load(QDir& d) const;

    int _rotateStepCount;
    mutable ComplexMatrix _rayleighCrossSpectrum;
    mutable ComplexMatrix _loveCrossSpectrum;
    mutable ComplexMatrix * _rayleighCrossSpectra;
    mutable ComplexMatrix * _loveCrossSpectra;
  };

} // namespace ArrayCore

#endif // CROSSSPECTRUM_H

