/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-05-08
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef CONVFKVERTICAL_H
#define CONVFKVERTICAL_H

#include "AbstractFKFunction.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT ConvFKVertical : public AbstractFKFunction
  {
  public:
    ConvFKVertical(FKCache * cache);

    void initialize(const FKParameters& param);
    FunctionSearch * createSearch(const FKParameters& param);

    void resetCrossSpectrum();
    void addCrossSpectrum();
    void meanCrossSpectrum(int nBlocks);
    void addIncoherentNoise(double, double vertical);

    double value(const Vector<int>& index) const;
    double value(Vector<double>& k) const;

    FK_PASSIVE_STEERING
  };

} // namespace ArrayCore

#endif // CONVFKVERTICAL_H

