/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-07-22
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ConvFKRayleigh.h"
#include "FKCrossSpectrum.h"

namespace ArrayCore {

  /*!
    \class ConvFKRayleigh ConvFKRayleigh.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  ConvFKRayleigh::ConvFKRayleigh(FKCache * cache)
    : AbstractFKRayleigh(cache)
  {
    cache->setPassiveSteering();
  }

  void ConvFKRayleigh::initialize(const FKParameters& param)
  {
    setPowerEngine(new FKPower(cache()->array()->count(), 2));
    steeringInitialization()->setSensorPositionErrors(param);
    steeringInitialization()->setSensorOrientationErrors(param);
    steeringInitialization()->setPhaseShifts(param.gridStep(), param.effectiveGridSize());
    _ellOptimization.setAbsolutePrecision(param.ellipticityAbsolutePrecision());
    AbstractFKRayleigh::initialize(param);
  }

  FunctionSearch * ConvFKRayleigh::createSearch(const FKParameters& param)
  {
    GridSearch2D * grid=new GridSearch2D(3);
    grid->setRelativePrecision(0, param.velocityRelativePrecision());
    grid->setRelativePrecision(1, param.velocityRelativePrecision());
    grid->setFunction(this);
    grid->setGrid(param.gridStep(), param.effectiveGridSize());
    return grid;
  }

  void ConvFKRayleigh::resetCrossSpectrum()
  {
    _crossSpectrum->resetRotatedMatrices();
  }

  void ConvFKRayleigh::addCrossSpectrum()
  {
    _crossSpectrum->addRotatedRayleigh(steering()->sensorOrientationErrors());
  }

  void ConvFKRayleigh::meanCrossSpectrum(int nBlocks)
  {
    _crossSpectrum->meanRotatedMatrices(nBlocks);
  }

  void ConvFKRayleigh::addIncoherentNoise(double horizontal, double vertical)
  {
    int n=_crossSpectrum->array().count();
    int rotCount=_crossSpectrum->rotationStepCount();
    for(int rotIndex=0; rotIndex<rotCount; rotIndex++) {
      ComplexMatrix& covmat=*_crossSpectrum->rotatedMatrix(rotIndex);
      for(int i=0; i<n; i++) {
        covmat.at(i, i)+=horizontal;
        covmat.at(i+n, i+n)+=vertical;
      }
    }
  }

  const ComplexMatrix * ConvFKRayleigh::crossSpectrum() const
  {
    if(_crossSpectrum) {
      return _crossSpectrum->rotatedMatrix(0);
    } else {
      return nullptr;
    }
  }

} // namespace ArrayCore

