/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-02-05
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ARRAYTIMEWINDOWS_H
#define ARRAYTIMEWINDOWS_H

#include "ArraySelection.h"
#include "ArrayParameters.h"
#include "ArrayStationSignals.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT ArrayTimeWindows
  {
    TRANSLATIONS("ArrayTimeWindows")
  public:
    ArrayTimeWindows(const ArraySelection * array,
                     const SparseKeepSignal * keep,
                     const ArrayParameters * param);
    ~ArrayTimeWindows();

    void setFrequencyIndex(int iOmega);
    void setFrequency(double f);
    void setWindows();
    void setWindows(const SeismicEvent * event);

    const TimeWindowList& list() const {return _list;}
    TimeWindowList& list() {return _list;}
    double timeRangeLength() const;

    const FrequencyBand& frequency() const {return _frequency;}
    int frequencyIndex() const {return _frequencyIndex;}
    const GaussianFrequencyBand * frequencyFilter() const {return _frequencyFilter;}
    const FourierPlan& plan() const {return *_plan;}
    const TaperDelegate& taper() const {return _taper;}
    QString toString(int index) const;
  private:
    void initPreprocessing();

    const ArrayParameters * _parameters;
    const SparseKeepSignal * _keep;

    double _samplingFrequency, _samplingPeriod;
    SeismicEventTable * _events;

    GaussianFrequencyBand * _frequencyFilter;
    FrequencyBand _frequency;
    int _frequencyIndex;
    TimeWindowList _list;
    FourierPlan * _plan;
    TaperDelegate _taper;
  };

} // namespace ArrayCore

#endif // ARRAYTIMEWINDOWS_H
