/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-09-17
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ActiveHRFKVertical.h"
#include "FKCrossSpectrum.h"

namespace ArrayCore {

  /*!
    \class ActiveHRFKVertical ActiveHRFKVertical.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  bool ActiveHRFKVertical::invertCrossSpectrum()
  {
    return _crossSpectrum->invert();
  }

  double ActiveHRFKVertical::value(Vector<double>& k) const
  {
    k[1]=0.0; // Only k[0] is modified by GridSearch
    if(isInsideLimits(k)) {
      const Vector<Complex>& e=_steering->oneComponent(k[0], powerEngine());
      powerEngine()->setHighResolutionValue(e);
      return powerEngine()->value();
    } else {
      return -1.0;
    }
  }

} // namespace ArrayCore

