/***************************************************************************
**
**  This file is part of warangps.
**
**  warangps is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  warangps is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-06-27
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef WARANGPSWIDGET_H
#define WARANGPSWIDGET_H

#include <SciFigs.h>

#include "ui_WaranGpsWidget.h"

class GpsStation;

class WaranGpsWidget : public QWidget, public Ui::WaranGpsWidget
{
  Q_OBJECT
public:
  WaranGpsWidget(QWidget * parent=nullptr);
  ~WaranGpsWidget();

  void polish();

  enum Mode {NoGps, Gps};

  void setMode(Mode m);
  void setGpsStations(quint16 port=2974);
  void setCoordinates(QString fileName=QString(), QString coordinateFormat=QString());
  void setFrequencySampling(const SamplingParameters& param);
  void setKmaxThreshold(double t);
private slots:
  void on_modeCombo_currentIndexChanged(int index);
  void on_gpsTrackBut_clicked();
  void on_gpsStackBut_clicked();
  void on_arrayCoordinateFactor_valueChanged(double d);
  void on_arrayLoadBut_clicked();
  void on_arraySaveBut_clicked();
  void on_relativePositionBut_clicked();
  void on_backgroundBut_clicked();
  void arrayChanged();
  void arrayMapChanged();
  void arrayTableChanged();
  void updateGps();
private:
  void updateUtmZone();
  static Point arrayCenter(const QList<NamedPoint>& array);
  void setMultipliedArray();
  virtual void closeEvent(QCloseEvent * e);
  void updateStatistics();
  void setArrayFromStatistics();
  void updateArrayResponse();
  void updateDistanceMap();
  void updateArrayMap();
  void updateCoArrayMap();

  CircleViewer * _distanceMapErrors;

  VectorList<RealStatisticalValue> _xStat;
  VectorList<RealStatisticalValue> _yStat;
  QList<GpsStation *> _gpsStations;
  QList<NamedPoint> _arrayBase;
  QList<NamedPoint> _arrayMultiplied;
  UtmZone _utmZone;
  QAction * _arrayEditAction;
  QTimer _gpsUpdate;
  RelativePositions * _relativePositions;
};

#endif // WARANGPSWIDGET_H
