/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2012-02-04
**  Copyright: 2012-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "SeismicParameterEditor.h"

/*!
  \class SeismicParameterEditor SeismicParameterEditor.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
SeismicParameterEditor::SeismicParameterEditor(QWidget * parent)
  : Dialog(parent)
{
  TRACE;
  setupUi(this);
  connect(hardwareGain, SIGNAL(activated(int)), this, SLOT(updateFields()));
  connect(sensorUnit, SIGNAL(activated(int)), this, SLOT(updateFields()));
  connect(voltPerUnit, SIGNAL(valueChanged(double)), this, SLOT(updateFields()));
}

/*!
  Description of destructor still missing
*/
SeismicParameterEditor::~SeismicParameterEditor()
{
  TRACE;
}

void SeismicParameterEditor::updateFields()
{
  TRACE;
  double bitCount=22.5; // Software gain set to 1
  double range=10.0;    // Software gain set to 1
  voltPerUnit->setSuffix(" V/("+sensorUnit->currentText()+")");
  switch(hardwareGain->currentIndex()) {
  default:
    break;
  case 1:
    range/=4.0;
    break;
  case 2:
    range/=16.0;
    break;
  case 3:
    range/=64.0;
    break;
  case 4:
    range/=1024.0;
    break;
  }
  voltageRange->setText("+/-"+QString::number(range)+" V");
  voltPerCount->setText(QString::number(2.0*range/16777215)+" V");
  adcResolutionBits->setText(QString::number(bitCount)+" bits");
  double adcResolution=2.0*range/(pow(2.0, bitCount)-1);
  adcResolutionVolts->setText(QString::number(adcResolution)+" V");
  totalResolution->setText(QString::number(adcResolution/voltPerUnit->value())+" "+sensorUnit->currentText());
}

void SeismicParameterEditor::getValues(SeismicParameters& p)
{
  TRACE;
  switch(samplingFrequency->currentIndex()) {
  case 0:
    p.setFrequency(10);
    break;
  case 1:
    p.setFrequency(20);
    break;
  case 2:
    p.setFrequency(25);
    break;
  case 3:
    p.setFrequency(40);
    break;
  case 4:
    p.setFrequency(50);
    break;
  case 5:
    p.setFrequency(80);
    break;
  default:
    p.setFrequency(100);
    break;
  case 7:
    p.setFrequency(125);
    break;
  case 8:
    p.setFrequency(200);
    break;
  case 9:
    p.setFrequency(250);
    break;
  case 10:
    p.setFrequency(400);
    break;
  }
  switch(hardwareGain->currentIndex()) {
  default:
    p.setHardwareGain(1);
    break;
  case 1:
    p.setHardwareGain(4);
    break;
  case 2:
    p.setHardwareGain(16);
    break;
  case 3:
    p.setHardwareGain(64);
    break;
  case 4:
    p.setHardwareGain(1024);
    break;
  }
}
