/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2012-02-08
**  Copyright: 2012-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef GPSLINK_H
#define GPSLINK_H

#include "DaemonLink.h"

class GpsLink : public DaemonLink
{
  Q_OBJECT
public:
  GpsLink(Station * station);
  ~GpsLink();

  void start(int duration);
  void stop();
  void state();
  void navigation();
  void raw();
  void abortRaw();

  void highRateRefresh();
protected:
  virtual void connected();
  virtual int bytesAvailable(const char * buffer, int bytesCount);
private slots:
  void refreshVariableParameters();
signals:
  void rawFileSize(int size);
  void rawFileReady();
  void rawFileError();
private:
  int saveRaw(const char * buffer, int bytesCount);
  void state(const char * buffer, int bytesRead, int bytesCount);

  QTimer _refresh;
  QElapsedTimer * _rawRecording;
  bool _rawMode;
  QFile _rawFile;
  int _rawFileSize;
  FletcherChecksum _rawChecksum;
};

#endif // GPSLINK_H
