/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-04-07
**  Copyright: 2013-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>

#include "DistanceDelegate.h"

/*!
  \class DistanceDelegate DistanceDelegate.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

DistanceDelegate::DistanceDelegate(QObject * parent, SortedStringList *pointNames)
  : ItemDelegate(parent)
{
  TRACE;
  _pointNames=pointNames;
}

QWidget * DistanceDelegate::createEditor(QWidget * parent, const QStyleOptionViewItem &,
                                         const QModelIndex & index) const
{
  TRACE;
  switch (index.column()) {
  case 0:
  case 1: {
      QComboBox * w=createComboBox(parent);
      w->addItems(_pointNames->list());
      w->setEditable(true);
      connect(w, SIGNAL(valueChanged(double)), this, SLOT(commitWidget()));
      return w;
    }
  default: {
      QDoubleSpinBox * w=createDoubleSpinBox(parent);
      w->setMinimum(0.0);
      w->setMaximum(std::numeric_limits<double>::infinity());
      w->setSuffix(" m");
      w->setDecimals(3);
      w->setSingleStep(0.01);
      connect(w, SIGNAL(valueChanged(double)), this, SLOT(commitWidget()));
      return w;
    }
  }
  return 0;
}

/*!
  Re-implemented to collect of point names
*/
void DistanceDelegate::setModelData(QWidget *editor, QAbstractItemModel *model,
                                    const QModelIndex &index) const
{
  TRACE;
  switch (index.column()) {
  case 0:
  case 1: {
      QComboBox * w=qobject_cast<QComboBox *>(editor);
      QString s=w->currentText();
      _pointNames->insert(s);
      break;
    }
  default:
    break;
  }
  ItemDelegate::setModelData(editor, model, index);
}
