/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-04-07
**  Copyright: 2013-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>

#include "Distance.h"

/*!
  \class Distance Distance.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

Distance::Distance(const QString& n1, const QString& n2, double v)
{
  TRACE;
  _node1=n1;
  _node2=n2;
  _measured=v;
  _computed=0.0;
}

QString Distance::toString(char format, int precision) const
{
  TRACE;
  return _node1+"\t"+_node2
      +"\t"+QString::number(_measured, format, precision)
      +"\t"+QString::number(_computed, format, precision);
}

bool Distance::fromString(const StringSection& str)
{
  TRACE;
  const QChar * ptr=0;
  StringSection f;
  bool ok=true;
  f=str.nextField(ptr);
  if(f.isValid()) _node1=f.toStringBuffer(); else return false;
  f=str.nextField(ptr);
  if(f.isValid()) _node2=f.toStringBuffer(); else return false;
  f=str.nextField(ptr);
  if(f.isValid()) _measured=f.toDouble(ok); else return false;
  f=str.nextField(ptr);
  if(f.isValid()) _computed=f.toDouble(ok);
  return ok;
}
