/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2012-12-12
**  Copyright: 2012-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef COMMENTSWIDGET_H
#define COMMENTSWIDGET_H

#include "ui_CommentsWidget.h"

class Station;

class CommentsWidget : public QWidget, private Ui::CommentsWidget
{
  Q_OBJECT
public:
  CommentsWidget(QWidget * parent=nullptr);
  ~CommentsWidget();

  void setStations(QList<Station *> * lists);
private slots:
  void on_stationList_currentIndexChanged(int index=-1);
  void on_addCurrent_clicked();
  void on_addAll_clicked();
  void stationChanged(int stationIndex);
  void commentsChanged(int stationIndex);
private:
  QString decoratedNewComment() const;

  QList<Station *> * _stations;
};

#endif // COMMENTSWIDGET_H
