/***************************************************************************
**
**  This file is part of gpviewmax.
**
**  gpviewmax is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpviewmax is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-07-16
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SAMPLE_H
#define SAMPLE_H

#include <QGpCoreTools.h>

class Sample
{
public:
  Sample();

  bool read(const QString& line);

  const DateTime& time() const {return _time;}
  double frequency() const {return _frequency;}
  double autocorr() const {return _autocorr;}
  int ring() const {return _ring;}

  void write(QTextStream& s, const QString& polarization) const;
private:
  DateTime _time;
  double _frequency, _autocorr;
  int _ring;
};

#endif // SAMPLE_H

