/***************************************************************************
**
**  This file is part of phaseit.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-08-09
**  Authors:
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "Plugin.h"
#include "ToolWidget.h"

#include "phaseitInstallPath.h"
#include "phaseitVersion.h"
#include "GeopsyCoreVersion.h"

/*!
  \class Plugin Plugin.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

const char * Plugin::interfaceVersion() const
{
  return GEOPSYCORE_VERSION;
}

void Plugin::createToolActions(QObject * toolFactory)
{
  TRACE;
  QAction * a;

  a=new QAction(toolFactory);
  a->setText(tr("Phase It"));
  a->setStatusTip(tr("Coherence, phase shifts and amplitude ratios between signals versus time"));
  a->setIcon(QIcon(":phaseit-22x22.png"));
  connect(a, SIGNAL(triggered()), toolFactory, SLOT(showTool()) );
  addAction(a);
}

AbstractToolWidget * Plugin::createTool(int id, QWidget * wsParent) const
{
  TRACE;
  switch (id) {
  case 0:
    return new ToolWidget(wsParent);
  default:
    break;
  }
  return nullptr;
}

PACKAGE_INFO("phaseit", PHASEIT)
#if(QT_VERSION < QT_VERSION_CHECK(5, 0, 0))
Q_EXPORT_PLUGIN2(phaseit, Plugin)
#endif
