/***************************************************************************
**
**  This file is part of gpvoronoi.
**
**  gpvoronoi is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpvoronoi is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-01-14
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "Reader.h"

/*!
  \class Reader Reader.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
Reader::Reader()
  : ArgumentStdinReader()
{
  _xColumn=0;
  _yColumn=1;
  _limits=nullptr;
  _delaunay=false;
}

/*!
  Description of destructor still missing
*/
Reader::~Reader()
{
}

bool Reader::setOptions(int& argc, char ** argv)
{
  TRACE;
  // Check arguments
  int i, j=1;
  for(i=1; i<argc; i++) {
    QByteArray arg=argv[i];
    if(arg[0]=='-') {
      if(arg=="-x-column") {
        CoreApplication::checkOptionArg(i, argc, argv);
        int xci=CoreApplication::toInt(i, i-1, argv);
        if(xci>=0) {
          _xColumn=xci;
        } else {
          App::log(tr("gpvoronoi: bad column index '%1' for option '-x-column'\n").arg(xci) );
          return 2;
        }
      } else if(arg=="-y-column") {
        CoreApplication::checkOptionArg(i, argc, argv);
        int yci=CoreApplication::toInt(i, i-1, argv);
        if(yci>=0) {
          _yColumn=yci;
        } else {
          App::log(tr("gpvoronoi: bad column index '%1' for option '-y-column'\n").arg(yci) );
          return 2;
        }
      } else if(arg=="-limits") {
        CoreApplication::checkOptionArg(i, argc, argv);
        double x1=CoreApplication::toDouble(i, i-1, argv);
        CoreApplication::checkOptionArg(i, argc, argv);
        double y1=CoreApplication::toDouble(i, i-2, argv);
        CoreApplication::checkOptionArg(i, argc, argv);
        double x2=CoreApplication::toDouble(i, i-3, argv);
        CoreApplication::checkOptionArg(i, argc, argv);
        double y2=CoreApplication::toDouble(i, i-4, argv);
        delete _limits;
        _limits=new Rect(x1, y1, x2, y2);
      } else if(arg=="-delaunay") {
        _delaunay=true;
      } else {
        App::log(tr("gpvoronoi: bad option %1, see -help.\n").arg(argv[i]));
        return 2;
      }
    } else {
      argv[j++]=argv[i];
    }
  }
  if(j < argc) {
    argv[j]=nullptr;
    argc=j;
  }
  return true;
}

bool Reader::parse(QTextStream& s)
{
  TRACE;
  QTextStream sOut(stdout);
  QList<Point2D> points;

  QString buf;
  bool ok=true;
  while(!s.atEnd()) {
    buf=s.readLine();
    if(!buf.isEmpty() && buf[0]!='\n' && buf[0]!='#') {
      LineParser parser(buf);
      Point2D p;
      p.setX(parser.toDouble(_xColumn, ok));
      p.setY(parser.toDouble(_yColumn, ok));
      if(!ok) {
        App::log(tr("Error parsing '%1'\n").arg(buf));
        return false;
      }
      points.append(p);
    }
  }
  DelaunayTriangulation triang;
  triang.init(points);
  VectorList<Curve<Point2D>> cellLimits;
  if(_delaunay) {
    cellLimits=triang.triangleEdges();
  } else {
    if(!_limits) {
      _limits=new Rect;
      for(int i=points.count()-1; i>=0; i--) {
        _limits->add(points.at(i));
      }
      _limits->enlarge(0.1, LinearScale, LinearScale);
    }
    cellLimits=triang.voronoiCells(*_limits);
  }
  for(int i=cellLimits.count()-1; i>=0; i--) {
    const Curve<Point2D>& c=cellLimits.at(i);
    sOut << "#\n" << c.toString();
  }
  return true;
}
