/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-11-25
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "SigmaNoiseProxy.h"

/*!
  \class SigmaNoiseProxy SigmaNoiseProxy.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

QString SigmaNoiseProxy::columnName(int col) const
{
  TRACE;
  switch(col) {
  case 2: return tr("Incoherent noise Rh/Rz");
  default: return FrequencyCurveProxy::columnName(col);
  }
}

QStringList SigmaNoiseProxy::columnFileTypes() const
{
  TRACE;
  QStringList types=FrequencyCurveProxy::columnFileTypes();
  types[2]=tr("Incoherent noise Rh/Rz");
  return types;
}
