/***************************************************************************
**
**  This file is part of gptarget.
**
**  gptarget is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gptarget is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-05-06
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <DinverCore.h>
#include <DinverDCCore.h>
#include <QGpCoreTools.h>
#include <QGpCoreWave.h>

#include "TargetMerge.h"

/*!
  \class TargetMerge TargetMerge.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
TargetMerge::TargetMerge()
    : AbstractTarget()
{
  TRACE;
}

/*!
  Description still missing
*/
bool TargetMerge::setOptions(int& argc, char ** argv)
{
  TRACE;
  int j=1;
  for(int i=1; i<argc; i++) {
    QByteArray arg=argv[i];
    if(arg[0]=='-') {
      if(arg=="-o") {
        CoreApplication::checkOptionArg(i, argc, argv);
        setFileName(argv[i]);
      } else {
        App::log(tr("gptarget: bad option %1, see -help\n").arg(argv[i]) );
        return false;
      }
    } else {
      argv[j++]=argv[i];
    }
  }
  if(j < argc) {
    argv[j]=nullptr;
    argc=j;
  }
  for(int i=1; i<argc; i++) {
    _targets.append(argv[i]);
  }
  if(_targets.isEmpty()) {
    App::log(tr("gptarget: missing 1D targets to merge\n") );
    return false;
  }
  return true;
}

/*!
  Description still missing
*/
int TargetMerge::execute()
{
  TRACE;
  TargetList2D tl;
  QFileInfo fi(fileName());
  if(fi.exists()) {
    XMLVirtualPlugin plugin(&tl, "DispersionCurve2D");
    XMLDinverHeader hdr(&plugin);
    if(hdr.xml_restoreFile(fileName())!=XMLClass::NoError) {
      App::log(tr("gptarget: error reading file %1\n").arg(fileName()) );
      return 2;
    }
  }
  foreach(QString fn, _targets) {
    TargetList * t=new TargetList;
    XMLVirtualPlugin plugin(t, "DispersionCurve");
    XMLDinverHeader hdr(&plugin);
    if(hdr.xml_restoreFile(fn)!=XMLClass::NoError) {
      App::log(tr("gptarget: error reading file %1\n").arg(fn) );
      delete t;
      return 2;
    }
    if(t->isEmpty()) {
      App::log(tr("gptarget: empty target %1\n").arg(fn) );
      delete t;
      return 2;
    }
    tl.addTarget(t);
  }
  XMLVirtualPlugin plugin(&tl, "DispersionCurve2D");
  XMLDinverHeader hdr(&plugin);
  if(hdr.xml_saveFile(fileName())!=XMLClass::NoError) {
    App::log(tr("gptarget: error writing to file %1\n").arg(fileName()) );
    return 2;
  }
  return 0;
}
