/***************************************************************************
**
**  This file is part of gpsh.
**
**  gpsh is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpsh is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-12-15
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SHREADER_H
#define SHREADER_H

#include <QGpCoreTools.h>

class ShReader : public ArgumentStdinReader
{
  TRANSLATIONS("ShReader")
public:
  ShReader();

  bool setOptions(int& argc, char ** argv);
protected:
  virtual bool parse(QTextStream& s);
private:  
  SamplingOption _samplingType;
  int _nSamples;
  double _minRange;
  double _maxRange;
  double _qp, _qs;
  double _receiverDepth, _referenceDepth;

  VectorList<double> _x;
};

#endif // SHREADER_H
