/***************************************************************************
**
**  This file is part of gplivemodel.
**
**  gplivemodel is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gplivemodel is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-06-15
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <SciFigs.h>

#include "Seismic1DThread.h"

/*!
  \class Seismic1DThread Seismic1DThread.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
Seismic1DThread::Seismic1DThread(QObject * parent)
    : CurvesThread(parent)
{
  TRACE;
  _vp=0;
  _vs=0;
  _leg=0;
}

/*!
  Description of constructor still missing
*/
Seismic1DThread::Seismic1DThread(const Seismic1DThread& o)
    : CurvesThread(o)
{
  TRACE;
  _vp=0;
  _vs=0;
  _leg=0;
}

/*!
  Description of destructor still missing
*/
Seismic1DThread::~Seismic1DThread()
{
  TRACE;
}

bool Seismic1DThread::setParameters(int& argc, char ** argv)
{
  TRACE;
  // TODO: add option for profile selection (rho, nu, vp, vs, qp, qs)
  return CurvesThread::setParameters(argc, argv);
}

void Seismic1DThread::initModelGraphs(GraphicSheet * sheet)
{
  TRACE;
  AxisWindow * w;

  w=new AxisWindow;
  w->setGeometry(sheet->printRight(), 0.5, 6.0, 8.0);
  w->yAxis()->setReversedScale(true);
  w->yAxis()->setTitle(tr("Depth (m)"));
  w->xAxis()->setTitle(tr("Vp (m/s)"));
  _vp=new LineLayer(w);
  _vp->setObjectName("background Vp");
  _vp->setReferenceLine(new PlotLine2D);
  sheet->addObject(w);
  sheet->showObject(w);

  w=new AxisWindow;
  w->setGeometry(sheet->printRight(), 0.5, 6.0, 8.0);
  w->yAxis()->setReversedScale(true);
  w->yAxis()->setTitle(tr("Depth (m)"));
  w->xAxis()->setTitle(tr("Vs (m/s)"));
  _vs=new LineLayer(w);
  _vs->setObjectName("background Vs");
  _vs->setReferenceLine(new PlotLine2D);
  sheet->addObject(w);
  sheet->showObject(w);

  _leg=createLegend(sheet, sheet->printRight(), 0.5, tr("Background models"));
  connect(_leg, SIGNAL(changed( Legend) ), _vp, SLOT(setLegend( Legend) ));
  connect(_leg, SIGNAL(changed( Legend) ), _vs, SLOT(setLegend( Legend) ));
}


void Seismic1DThread::initModelGraphs(const ResultsThread& o)
{
  TRACE;
  const Seismic1DThread& os=static_cast<const Seismic1DThread&>(o);
  AxisWindow * w;

  w=os._vp->graph();
  _vp=new LineLayer(w);
  _vp->setObjectName("foreground Vp");
  _vp->setReferenceLine(new PlotLine2D);
  _vp->addLine(Pen(), Symbol());

  w=os._vs->graph();
  _vs=new LineLayer(w);
  _vs->setObjectName("foreground Vs");
  _vs->setReferenceLine(new PlotLine2D);
  _vs->addLine(Pen(), Symbol());

  _leg=createLegend(w->sheet(), os._leg->printLeft(), 4.5, tr("Foreground models"));
  connect(_leg, SIGNAL(changed( Legend) ), _vp, SLOT(setLegend( Legend) ));
  connect(_leg, SIGNAL(changed( Legend) ), _vs, SLOT(setLegend( Legend) ));
}

void Seismic1DThread::addModel(GeophysicalModel * m)
{
  TRACE;
  Seismic1DModel * ms=static_cast<Seismic1DModel *>(m);
  int i;
  const Legend& leg=_leg->legend();
  PlotLine2D * line;
  i=_vp->count();
  line=static_cast<PlotLine2D *>(_vp->addLine(leg.pen(i), leg.symbol(i)) );
  line->curve()=ms->vpProfile().curve();
  i=_vs->count();
  line=static_cast<PlotLine2D *>(_vs->addLine(leg.pen(i), leg.symbol(i)) );
  line->curve()=ms->vsProfile().curve();
}

void Seismic1DThread::setModel(GeophysicalModel * m)
{
  TRACE;
  Seismic1DModel * ms=static_cast<Seismic1DModel *>(m);
  static_cast<PlotLine2D *>(_vp->line(0) )->curve()=ms->vpProfile().curve();
  static_cast<PlotLine2D *>(_vs->line(0) )->curve()=ms->vsProfile().curve();
}

void Seismic1DThread::clear()
{
  TRACE;
  CurvesThread::clear();
  _vp->clear();
  _vs->clear();
}

void Seismic1DThread::modelDeepUpdate()
{
  _vp->graph()->deepUpdate();
  _vs->graph()->deepUpdate();
}

void Seismic1DThread::setModelLimits()
{
  TRACE;
  Rect rp=_vp->graphContents()->boundingRect();
  Rect rs=_vs->graphContents()->boundingRect();
  _vp->graph()->xAxis()->setRange(0.0, rp.x2()*1.1);
  _vs->graph()->xAxis()->setRange(0.0, rs.x2()*1.1);
  double maxDepth=rp.y2() > rs.y2() ? rp.y2() : rs.y2();
  maxDepth*=1.1;
  _vp->graph()->yAxis()->setRange(0.0, maxDepth);
  _vs->graph()->yAxis()->setRange(0.0, maxDepth);
}
