/***************************************************************************
**
**  This file is part of gplivemodel.
**
**  gplivemodel is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gplivemodel is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-12-15
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LIVEMODELREADER_H
#define LIVEMODELREADER_H

#include <QGpCoreTools.h>

#include "Results.h"
#include "ResultsThread.h"

class MainWindow;

class LiveModelReader : public ArgumentStdinReader
{
  TRANSLATIONS("LiveModelReader")
public:
  LiveModelReader();
  ~LiveModelReader();

  bool setOptions(int& argc, char ** argv);
  int exec();
protected:
  virtual bool parse(QTextStream& s);
private:
  Results::CurveType _curveType;
  bool _readStdin;
  QString _panelFile;
  QString _sliderName;
  int _scanCount;

  MainWindow  * _w;
};

#endif // LIVEMODELREADER_H
