/***************************************************************************
**
**  This file is part of gphistogram.
**
**  gphistogram is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gphistogram is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-08-21
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "GaussianMixtureOutput.h"

/*!
  \class GaussianMixtureOutput GaussianMixtureOutput.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
GaussianMixtureOutput::GaussianMixtureOutput(QObject * parent)
  : QObject(parent)
{
  TRACE;
}

/*!
  Description of destructor still missing
*/
GaussianMixtureOutput::~GaussianMixtureOutput()
{
  TRACE;
}

void GaussianMixtureOutput::newValues(int index)
{
  TRACE;
  GaussianMixtureDistribution d=filter(index);
  double x=_inversion->histogram(0)->x(index);
  SamplingOptions ySampling=_inversion->histogram(0)->ySampling();
  RealStatisticalPoint p;
  QTextStream sOut(stdout);
  for(int i=0; i<d.modeCount(); i++) {
    p.setX(x);
    if(ySampling & LogScale) {
      p.setMean(exp(d.mode(i).mean(0)));
      p.setStddev(exp(d.mode(i).stddev(0)));
    } else if(ySampling & InverseScale) {
      p.setMean(1.0/d.mode(i).mean(0));
      p.setStddev(1.0/d.mode(i).stddev(0));
    } else {
      p.setMean(d.mode(i).mean(0));
      p.setStddev(d.mode(i).stddev(0));
    }
    p.setWeight(d.weight(i));
    sOut << p.toString() << Qt::endl;
  }
}

GaussianMixtureDistribution GaussianMixtureOutput::filter(int index) const
{
  TRACE;
  double x=_inversion->histogram(0)->x(index);
  App::freeze(false);
  App::log(tr("Best misfit %1 at x %2 Hz (model index %3 over %4)\n")
                   .arg(_inversion->bestMisfit())
                   .arg(x)
                   .arg(_inversion->bestMisfitIndex().value())
                   .arg(_inversion->modelCount()));
  App::log(_inversion->humanSolution(index, "# "));

  GaussianMixtureDistribution d=_inversion->distribution(index);
  // Exclude outside kmin and kmax
  if(_inversion->parameters().kmin()>0.0 && _inversion->parameters().kmax()>_inversion->parameters().kmin()) {
    // Remove 1% to account for precision errors in parameter discretization
    // We want to remove solution that at too close to limits
    d.filterRange(0, 1.01*_inversion->parameters().kmin(), 0.99*_inversion->parameters().kmax());
  }
  // Remove modes with large standard devition and small amplitude
  d.filterDominantModes(2.0);
  // Remove small weights
  d.filterWeight(0.01);
  App::freeze(true);
  return d;
}

