/***************************************************************************
**
**  This file is part of gpfksimulator.
**
**  gpfksimulator is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpfksimulator is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-11-08
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SIMULATEDCROSSSPECTRUM_H
#define SIMULATEDCROSSSPECTRUM_H

#include <ArrayCore.h>

#include "SourceSignal.h"
#include "Parameters.h"

class SimulatedCrossSpectrum : public FKCrossSpectrum
{
public:
  SimulatedCrossSpectrum(const ArraySelection * array,
                         const Parameters * param);
  ~SimulatedCrossSpectrum();

  void setWaveModel(SourceParameters::WaveModel wm) {_waveModel=wm;}
  SourceParameters::WaveModel waveModel() const {return _waveModel;}

  void setSensorRotation(double a) {_sensorRotation=a;}
  double sensorRotation() const {return _sensorRotation;}

  void addSource();
  void setSourceCount(int nSrc);
  void removeSource(int index);
  void setSourceSignals(int iSrc, const SourceParameters& src,
                        const MediumParameters& medium, int blockCount);
  int sourceCount() const {return _sourceSig.count();}

  void setStationSignals(int blockCount, double verticalNoise, double horizontalNoise);

  bool calculate(int blockCount, AbstractFKFunction * function,
                 const Parameters& param);

  Point setActiveSource(const VectorList<int>&, bool& ok);

  void addVertical();
  void addThreeComponent(const Complex * sensorRotations);
  void addActiveVertical(const ActiveFKSteering& geom);
  void addActiveRayleigh(const ActiveFKSteering& geom);
  void addActiveTransverse(const ActiveFKSteering& geom);
protected:
  void addRotatedRadial(int rotationIndex, const Complex * sensorRotations);
  void addRotatedTransverse(int rotationIndex, const Complex * sensorRotations);
  void addRotatedRayleigh(int rotationIndex, const Complex * sensorRotations);
private:
  void clearSignals();

  static GlobalRandom * _noisePhaseGenerator;
  int _currentBlock;
  double _sensorRotation;
  SourceParameters::WaveModel _waveModel;
  Complex *** _stationSig;
  VectorList<SourceSignal *> _sourceSig;
};

#endif // SIMULATEDCROSSSPECTRUM_H

