/***************************************************************************
**
**  This file is part of gpcoord.
**
**  gpcoord is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpcoord is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2023-11-06
**  Copyright: 2023
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef TRANSLATIONROTATIONFORWARD_H
#define TRANSLATIONROTATIONFORWARD_H

#include <DinverCore.h>

class TranslationRotationForward : public AbstractForward
{
public:
  TranslationRotationForward();
  TranslationRotationForward(const TranslationRotationForward& o);

  void setReferencePoints(const QMap<QString, Point>& ref) {_refPoints=ref;}
  void setPoints(const VectorList<NamedPoint>& p) {_points=p;}
  void setFixedTranslation();

  const Point2D& fixedTranslation() const {return _fixedTranslation;}
  void reportErrors(QTextStream& s, double dx, double dy, double rot) const;

  AbstractForward * clone() const;
  double misfit(double * model, bool& ok);
private:
  QMap<QString, Point> _refPoints;
  VectorList<NamedPoint> _points;
  Point2D _fixedTranslation;
  double _maxDistance;
};

#endif // TRANSLATIONROTATIONFORWARD_H

