/***************************************************************************
**
**  This file is part of geopsyhv.
**
**  geopsyhv is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyhv is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-08-24
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpGuiTools.h>
#include <SciFigs.h>
#include "HVRotateResultSheet.h"
#include "HVRotateStation.h"

/*!
  \class HVRotateResultSheet HVRotateResultSheet.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
HVRotateResultSheet::HVRotateResultSheet(QWidget * parent)
    : RotateResultSheet(parent)
{
  TRACE;
  setValueTitle(tr("H/V"));
  Settings::getSize(this, "HVRotateResultSheet");
}

/*!
  Description of destructor still missing
*/
HVRotateResultSheet::~HVRotateResultSheet()
{
  TRACE;
  Settings::setSize(this, "HVRotateResultSheet");
}

void HVRotateResultSheet::setWindowTitle(QString subPoolName)
{
  TRACE;
  QWidget::setWindowTitle(tr("H/V Rotate Results - ")+subPoolName);
}
