/***************************************************************************
**
**  This file is part of geopsydamping.
**
**  geopsydamping is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsydamping is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-11-14
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "ToolDamping.h"
#include "DampingPlugin.h"

#include "geopsydampingInstallPath.h"
#include "geopsydampingVersion.h"
#include "GeopsyCoreVersion.h"

const char * DampingPlugin::interfaceVersion() const
{
  return GEOPSYCORE_VERSION;
}

void DampingPlugin::createToolActions(QObject * toolFactory)
{
  TRACE;
  QAction * a;

  a=new QAction(toolFactory);
  a->setText(tr("Damping"));
  a->setIcon(QIcon(":damping-22x22.png"));
  a->setStatusTip(tr("Random decrement technique to identify industrial noise."));
  connect(a, SIGNAL(triggered()), toolFactory, SLOT(showTool()) );
  addAction(a);
}

AbstractToolWidget * DampingPlugin::createTool(int id, QWidget * wsParent) const
{
  TRACE;
  switch (id) {
  case 0:
    return new ToolDamping(wsParent);
  default:
    return 0;
  }
}

PACKAGE_INFO("geopsydamping", GEOPSYDAMPING)
#if(QT_VERSION < QT_VERSION_CHECK(5, 0, 0))
Q_EXPORT_PLUGIN2(geopsydamping, DampingPlugin)
#endif
