/***************************************************************************
**
**  This file is part of dinverext.
**
**  dinverext is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinverext is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-04-10
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef EXTPLUGIN_H
#define EXTPLUGIN_H

#include <DinverGui.h>

class ExtTargetWidget;
class ExtTarget;
class ExtInversion;

class ExtPlugin : public DinverInterface
{
  Q_OBJECT
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
  Q_PLUGIN_METADATA(IID "org.geopsy.dinverInterface")
#endif
  Q_INTERFACES(DinverCore::DinverInterface)
public:
  ExtPlugin();
  ~ExtPlugin();

  DinverInterface * clone();

  QString tag() const;
  QString title() const ;
  QString version() const ;
  QString description() const ;

  QWidget * createTargetWidget();
  QWidget * createParamWidget();

  bool xmlSupport() const {return true;}
  void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  XMLMember xml_member(XML_MEMBER_ARGS);
  bool xml_polishChild(XML_POLISHCHILD_ARGS);
  const char * interfaceVersion() const;

  AbstractForward * createForward();
  bool initForward(AbstractForward * forward);
  void setCurrentForward(AbstractForward * forwards, const QString& );
private slots:
  void checkScript();
private:
  ParamSpaceEditor * _paramWidget;
  ExtTargetWidget * _targetWidget;
  // Global and batch definition of parameters and target
  // Null when global selection is active
  ParamSpaceScript * _param;
  ExtTarget * _target;
};

#endif // EXTPLUGIN_H
