/***************************************************************************
**
**  This file is part of dinverdc.
**
**  dinverdc is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinverdc is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-11-08
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef RINGBROWSER_H
#define RINGBROWSER_H

#include <QGpCoreWave.h>

#include "ui_RingBrowser.h"

class RingBrowser : public QWidget, private Ui::RingBrowser
{
  Q_OBJECT
public:
  RingBrowser(QWidget * parent=nullptr);
  ~RingBrowser();

  void setRing(int index, const AutocorrRing& ring);
  const AutocorrRing& at(int index) const {return _rings.at(index);}
  int count() const {return _rings.count();}
  void setCurrent(int index);
  int current() const;
  int indexOf(const AutocorrRing& ring);
  void add();
  void clear();
  void setEditable(bool e);
private slots:
  void on_currentRing_currentIndexChanged(int);
  void on_addRingBut_clicked();
  void on_removeRingBut_clicked();
  void on_minRadiusEdit_valueChanged(double val);
  void on_maxRadiusEdit_valueChanged(double val);
signals:
  void currentChanged(int index);
  void added(int index);
  void removed(int index);
  void nameChanged(int index, QString name);
private:
  QString name(int index);
  void setName(int index);
  void setEnabled(bool e);

  VectorList<AutocorrRing> _rings;
};

#endif // RINGBROWSER_H
