/***************************************************************************
**
**  This file is part of dinverdc.
**
**  dinverdc is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinverdc is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-08-08
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QLabel>

#include <QGpGuiTools.h>
#include <QGpGuiWave.h>
#include <SciFigs.h>

#include "RefractionTargetWidget.h"

/*!
  \class RefractionTargetWidget RefractionTargetWidget.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
RefractionTargetWidget::RefractionTargetWidget(QWidget* parent)
  : CurveBrowser(parent)
{
  TRACE;
  TODO_WARNING;

  //QHBoxLayout * layout=new QHBoxLayout;
  /*_sourceLabel=new QLabel(curveBox);
  _sourceLabel->setText(tr( "Source location" ));
  layout->addWidget(_sourceLabel);
  _sourceEdit=new DoubleSpinBox(curveBox);
  _sourceEdit->setSuffix( " m" );
  _sourceEdit->setDecimals(2);
  _sourceEdit->setMinimum( -std::numeric_limits<double>::infinity());
  _sourceEdit->setMaximum(std::numeric_limits<double>::infinity());
  layout->addWidget(_sourceEdit);
  connect(_sourceEdit, SIGNAL(valueChanged( double) ), this, SLOT(sourceChanged( double) ));
  QVBoxLayout * vboxLayout=qobject_cast<QVBoxLayout *>(curveBox->layout());
  ASSERT(vboxLayout);
  vboxLayout->addLayout(layout);

  AxisWindow * w=new AxisWindow(this);
  dock(w);
  // TODO add layer for sources
  LineLayer * l=new LineLayer(w);
  // Restrict layer to plot only RefractionLine
  RefractionLine * refLine=new RefractionLine;
  refLine->setPen(Pen( Qt::black, 0.6) );
  refLine->setSymbol(Symbol(Symbol::Circle, 1.2, Pen(Qt::black, 0.0),
                            Brush(Qt::black, Qt::SolidPattern) ));
  l->setReferenceLine(refLine);
  setProxy(new RefractionProxy);
  initLayer(l);
  setCurrentLayer(l);
  setWindowTitle(tr("Refraction target"));
  */

  setPlotProxy(new RefractionPlotProxy);
}

/*!
  Description of destructor still missing
*/
RefractionTargetWidget::~RefractionTargetWidget()
{
  TRACE;
  WidgetRect::saveRect(this);
}

void RefractionTargetWidget::resizeEvent(QResizeEvent * e)
{
  TRACE;
  WidgetRect::record(this);
  CurveBrowser::resizeEvent(e);
}

RefractionCurve& RefractionTargetWidget::curve(int index) const
{
  TRACE;
  return static_cast<RefractionLine *>(currentLayer()->line(index))->curve();
}

void RefractionTargetWidget::sourceChanged(double loc)
{
  TRACE;
  int i=currentLine();
  if(i>=0) {
    curve(i).setSource(loc);
  }
}

QList<RefractionCurve> RefractionTargetWidget::curves() const
{
  TRACE;
  QList<RefractionCurve> l;
  int n=count();
  for(int i=0;i<n;i++) {
    RefractionCurve& c=curve(i);
    l.append(c);
  }
  return l;
}

void RefractionTargetWidget::addCurve(const RefractionCurve& curve)
{
  TRACE;
  RefractionLine * line=static_cast<RefractionLine *>(currentLayer()->addLine());
  line->setCurve(curve);
}

void RefractionTargetWidget::addCurves(const QList<RefractionCurve>& curves)
{
  TRACE;
  int curvesCount=count();
  for(QList<RefractionCurve>::const_iterator it=curves.begin();it!=curves.end();it++) {
    addCurve( *it);
  }
  if(curvesCount==0) setLimits();
}

void RefractionTargetWidget::on_curveScroll_valueChanged(int v)
{
  TRACE;
  Q_UNUSED(v);
  TODO_WARNING;
  //CurveBrowser::on_curveScroll_valueChanged(v);
  bool b=count() > 0;
  _sourceLabel->setEnabled(b);
  _sourceEdit->setEnabled(b);
  if(count()==0) {
    _sourceEdit->setValue(0.0);
  } else {
    /*int i=curveScroll->value();
    RefractionCurve& c=curve(i);
    _sourceEdit->setValue(c.source());*/
  }
}

/*!

*/
void RefractionTargetWidget::setLimits()
{
  TRACE;
  AxisWindow * w=currentLayer()->graph();
  Rect r=w->graphContents()->boundingRect();
  w->xAxis()->setRange(r.x1() * 0.95, r.x2() * 1.05);
  w->yAxis()->setRange(0.0, r.y2() * 1.05);
}
