/***************************************************************************
**
**  This file is part of dinver.
**
**  dinver is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinver is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-31
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <DinverCore.h>
#include "NAModelsPlotProperties.h"
#include "NAModelsPlot.h"

/*
 *  Constructs a Tab_NAModelsPlot as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 */
NAModelsPlotProperties::NAModelsPlotProperties(QWidget* parent)
    : PropertyWidget(parent)
{
  TRACE;
  setupUi(this);

  addProperty(DotDiameter, dotDiam, dotDiamLabel);
  addProperty(ParamX, paramListX, paramListXLabel);
  addProperty(ParamY, paramListY, paramListYLabel);
}

void NAModelsPlotProperties::setParameterList(const InversionThread * t)
{
  TRACE;
  int n=t->variableParameterCount();
  for(int i=0;i < n;i++ ) {
    QString str=tr( "%1 (%2)").arg(t->variableParameter(i)->name())
                                .arg(t->variableParameter(i)->unit());
    paramListX->addItem(str);
    paramListY->addItem(str);
  }
}

int NAModelsPlotProperties::paramX()
{
  TRACE;
  return paramListX->currentIndex() - 1;
}

int NAModelsPlotProperties::paramY()
{
  TRACE;
  return paramListY->currentIndex() - 1;
}
