/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-07-04
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef XMLSCIFIGS_H
#define XMLSCIFIGS_H

#include <QGpCoreTools.h>

#include "SciFigsDLLExport.h"

namespace SciFigs {

class SCIFIGS_EXPORT XMLSciFigs : public XMLClass, public XMLContext
{
  TRANSLATIONS( "XMLSciFigs" )
public:
  XMLSciFigs();

  const QString& xml_tagName() const {return xmlSciFigsTag;}
  static const QString xmlSciFigsTag;

  enum FileType{None=0, MakeUp=1, Data=2, PageHeader=4, Layer=3, Page=7, Selection=8};
  Q_DECLARE_FLAGS(FileTypes, FileType)

  enum LayerMode {AppendLayer, PrependLayer};

  XMLClass::Error saveFile(QString fileName, const XMLClass * object, FileTypes type);
  QString saveString(const XMLClass * object, FileTypes type);
  QByteArray saveByteArray(const XMLClass * object, FileTypes type);
  XMLClass::Error restoreFile(QString fileName, XMLClass * object, FileTypes type);
  XMLClass::Error restoreString(QString s, XMLClass * object, FileTypes type);
  XMLClass::Error restoreByteArray(QByteArray data, XMLClass * object, FileTypes type);
  bool restoring() {return _currentFile!=None;}
  bool data() {return _currentFile & Data;}
  bool makeUp() {return _currentFile & MakeUp;}
  bool layer() {return _currentFile==Layer;}
  bool selection() {return _currentFile & Selection;}
  QString currentFileVersion() {return _currentFileVersion;}
  void setLayerMode(LayerMode m) {_layerMode=m;}
  LayerMode layerMode() const {return _layerMode;}
protected:
  void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  bool xml_setProperty(XML_SETPROPERTY_ARGS);
  XMLMember xml_member(XML_MEMBER_ARGS);
private:
  FileTypes _currentFile;
  QString _currentFileVersion;
  const XMLClass * _currentObject;
  LayerMode _layerMode;
};

} // namespace SciFigs

Q_DECLARE_OPERATORS_FOR_FLAGS(SciFigs::XMLSciFigs::FileTypes)

#endif // XMLSCIFIGS_H
